
// ARNote
/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\arnote.cpp,v 1.5 2002-08-29 12:12:31+02 renz Exp $ 

$Id: arnote.cpp,v 1.5 2002-08-29 12:12:31+02 renz Exp $ 

$Log: arnote.cpp,v $
Revision 1.5  2002-08-29 12:12:31+02  renz
Added RCS Headers
 

$Author: renz $ 

$Date: 2002-08-29 12:12:31+02 $ 

$Locker:  $ 

$Revision: 1.5 $ 

$Name:  $ 

$RCSfile: arnote.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\arnote.cpp,v $ 

*/
#include "AbstrctR\AbstrctO\ARNote.h"

int gd_noteName2pc(const char *name);
const char * gd_pc2noteName(int pitch);

// Class ARNote 

ARNote::ARNote(long theNumerator, long theDenominator)
  : ARMusicalEvent(theNumerator,theDenominator),
    name("noname"),
    pitch(UNKNOWN),
    intensity(MIN_INTENSITY),
    accidentals(0),
    octave(MIN_REGISTER)
//	,
//	tags(NULL)
{
	//fprintf(stderr,"ARNote constructed\n");
}

ARNote::ARNote(const TYPE_DURATION durationOfNote)
  : ARMusicalEvent(durationOfNote),
    name("empty"),
    pitch(UNKNOWN),
    intensity(MIN_INTENSITY),
    accidentals(0),
    octave(MIN_REGISTER)
  //	,tags(NULL)
  //## end ARNote::ARNote%856462245.initialization
{
  //## begin ARNote::ARNote%856462245.body preserve=yes
	//fprintf(stderr,"ARNote constructed\n");
  //## end ARNote::ARNote%856462245.body
}

ARNote::ARNote(const TYPE_TIMEPOSITION relativeTimePositionOfNote,
	const TYPE_DURATION durationOfNote)
  //## begin ARNote::ARNote%851665082.hasinit preserve=no
  //## end ARNote::ARNote%851665082.hasinit
  //## begin ARNote::ARNote%851665082.initialization preserve=yes
  : ARMusicalEvent((TYPE_TIMEPOSITION) relativeTimePositionOfNote,
		   (TYPE_TIMEPOSITION) durationOfNote),
    name("noname"),
    pitch(UNKNOWN),
    intensity(MIN_INTENSITY),
    accidentals(0),    
    octave(MIN_REGISTER)
  // ,tags(NULL)
  //## end ARNote::ARNote%851665082.initialization
{
  //## begin ARNote::ARNote%851665082.body preserve=yes
	//fprintf(stderr,"ARNote constructed\n");
  //## end ARNote::ARNote%851665082.body
}

ARNote::ARNote(TYPE_NAME theName, TYPE_ACCIDENTALS theAccidentals,
	TYPE_REGISTER theRegister, int theNumerator, int theDenominator,
	TYPE_INTENSITY theIntensity)
  //## begin ARNote::ARNote%858535944.hasinit preserve=no
  //## end ARNote::ARNote%858535944.hasinit
  //## begin ARNote::ARNote%858535944.initialization preserve=yes
  : ARMusicalEvent(theNumerator,theDenominator),
    name(theName),
    intensity(theIntensity),
    accidentals(theAccidentals),
    octave(theRegister)
	// ,tags(NULL)
  //## end ARNote::ARNote%858535944.initialization
{
  //## begin ARNote::ARNote%858535944.body preserve=yes
	//ASSERT(name.GetLength()==1);
	//ASSERT(strstr(NOTE_NAMES,name)); // erstmal so, spaeter auch "cis","es" erlaubt!
	ASSERT(octave>=MIN_REGISTER);
	ASSERT(octave<=MAX_REGISTER);
	ASSERT(accidentals>=MIN_ACCIDENTALS);
	ASSERT(accidentals<=MAX_ACCIDENTALS);

	// Hier wird der Pitch festgelegt
	pitch = UNKNOWN;

	name.to_lower();

	pitch = gd_noteName2pc(name.c_str());

/*
	if (name =="c")
	  pitch = NOTEC;
	 else if (name =="d")
	  pitch = NOTED;
	 else if (name =="e")
	  pitch = NOTEE;
	 else if (name =="f")
	  pitch = NOTEF;
	 else if (name =="g")
	  pitch = NOTEG;
	 else if (name =="a")
	  pitch = NOTEA;
	 else if (name =="h")
	  pitch = NOTEH; */

	//fprintf(stderr,"ARNote constructed\n");
  //## end ARNote::ARNote%858535944.body
}

ARNote::ARNote(const ARNote &arnote)
: ARMusicalEvent( (const ARMusicalEvent &) arnote),
  name((const ARName &) arnote.name)
{
	accidentals = arnote.accidentals;
	intensity = arnote.intensity;
	octave = arnote.octave;
	pitch = arnote.pitch;
}

ARNote::~ARNote()
{
  //## begin ARNote::~ARNote%.body preserve=yes

	//if (tags)
	//	delete tags;
	//fprintf(stderr,"ARNote destructed.\n");
  //## end ARNote::~ARNote%.body
}

ARMusicalObject * ARNote::Copy() const
{
	return new ARNote(*this);
}


//## Other Operations (implementation)
void ARNote::print() const
{
  /*  //## begin ARNote::print%856462241.body preserve=yes
  	fprintf(stderr,"(%.2f:",(double) relativeTimePosition);
	name.print();
	if(accidentals>0) for(int i=0;i<accidentals;i++)fprintf(stderr,"#");
	else if(accidentals<0) for(int i=0;i>accidentals;i--)fprintf(stderr,"&");
	fprintf(stderr,"%d*%ld/%ld)",octave,duration.getNumerator(),duration.getDenominator());
  //## end ARNote::print%856462241.body
  */
}

ostream & ARNote::operator<<(ostream &os) const
{
	os << name;
	if(accidentals>0) for(int i=0;i<accidentals;i++) os << "#";
	else if(accidentals<0) for(int i=0;i>accidentals;i--) os << "&";

	// here we have to "uncalculate" the dots ...
	// there is a distinction between notes that
	// were put in with dots and those that weren't.

	TYPE_DURATION tmpdur = duration;
	if (points==1)
	{
		tmpdur.setNumerator(2);
		tmpdur.normalize();
	}
	else if (points == 2)
	{
		tmpdur.setNumerator(4);
		tmpdur.normalize();
	}
	else if (points != 0)
	{
		// there can only be 0,1, or 2 dots
		ASSERT(FALSE);
			
	}

	os << octave << "*" << 
		tmpdur.getNumerator() << "/" <<
		tmpdur.getDenominator();
	for (int i=0;i< (int) points;i++)
	{
		os << ".";
	}
	os << " ";
	return os;
}

//TagList* ARNote::getTags()
//{
  //## begin ARNote::getTags%857087711.body preserve=yes
//	return tags;
  //## end ARNote::getTags%857087711.body
//}

//void ARNote::addTag(ARMusicalTag* tag)
//{
	// ACHTUNG : Klaerung !? Tags gehoren zu Noten
	// Nein ? -> was ist bei Ranges ... ?
//	if(!tags) tags=new TagList(0); // NONONO: owns Elements!
//	tags->AddTail(tag);
//}

void ARNote::addFlat()
{
  //## begin ARNote::addFlat%858535952.body preserve=yes
	accidentals--;
	ASSERT(accidentals>=MIN_ACCIDENTALS);
  //## end ARNote::addFlat%858535952.body
}

void ARNote::addSharp()
{
  //## begin ARNote::addSharp%858535953.body preserve=yes
	accidentals++;
	ASSERT(accidentals<=MAX_ACCIDENTALS);
  //## end ARNote::addSharp%858535953.body
}

void ARNote::setRegister(TYPE_REGISTER newRegister)
{
  //## begin ARNote::setRegister%858535958.body preserve=yes
	ASSERT(newRegister>=MIN_REGISTER);
	ASSERT(newRegister<=MAX_REGISTER);
	octave=newRegister;
  //## end ARNote::setRegister%858535958.body
}

const ARNoteName & ARNote::getName() const
{
  //## begin ARNote::getName%860105237.body preserve=yes
	return name;
  //## end ARNote::getName%860105237.body
}

TYPE_REGISTER ARNote::getOctave() const
{
  //## begin ARNote::getName%860105237.body preserve=yes
	return octave;
  //## end ARNote::getName%860105237.body
}

TYPE_PITCH ARNote::getPitch() const
{
  //## begin ARNote::getName%860105237.body preserve=yes
	return pitch;
  //## end ARNote::getName%860105237.body
}

void ARNote::offsetpitch(int steps)
{
  //  printf("inside offsetpitch\n");
  // this just tries to offset the pitch ...
  if (pitch >= NOTE_C && pitch <= NOTE_H)
    {
      //    printf("pitch is %d\n",pitch);
      int tmppitch = pitch-NOTE_C;
      // printf("tmppitch (pitch-NOTE_C) %d\n",tmppitch);
      tmppitch += steps;
      // printf("tmppitch (+=steps) %d\n",tmppitch);
      int regchange = 0;
      while (tmppitch > 6)
	{
	  tmppitch -= 7;
	  regchange++;
	}
      while (tmppitch < 0)
	{
	  tmppitch += 7;
	  regchange--;
	}
      
      //printf("tmppitch & regchange  %d, %d\n",tmppitch, regchange);
      pitch = tmppitch + NOTE_C;
      // printf("pitch: (tmppitch + NOTE_C) %d\n",pitch);
      if (regchange)
	{
	  // printf("octave before %d\n",octave);
	  octave += regchange;
	  // printf("octave after (+=regchange) %d\n",octave);
	}

      name.setName(gd_pc2noteName(pitch));
    }
  else
    {
      // we do not care right now ...
    }
}

void ARNote::setPitch(TYPE_PITCH newpitch)
{
	pitch = newpitch;
	name.setName(gd_pc2noteName(pitch));
}

void ARNote::setAccidentals(TYPE_ACCIDENTALS theAccidentals)
{
  //## begin ARNote::setAccidentals%860299152.body preserve=yes
	ASSERT(accidentals>=MIN_ACCIDENTALS);
	ASSERT(accidentals<=MAX_ACCIDENTALS);
	accidentals=theAccidentals;
  //## end ARNote::setAccidentals%860299152.body
}


// Additional Declarations
//## begin ARNote.declarations preserve=yes
//## end ARNote.declarations






int ARNote::CanBeMerged(const ARMusicalEvent *ev2)
{

	if (ARMusicalEvent::CanBeMerged(ev2))
	{
		// type is OK (checked in ARMusicalEvent)
		const ARNote *arn = dynamic_cast<const ARNote *>(ev2);
		if (!arn) return 0;
		
		if (arn->pitch == this->pitch 
			&& arn->octave == this->octave)
			return 1;
	}

	return 0;
}

void ARNote::setDuration(const TYPE_DURATION &newdur)
{
	ARMusicalEvent::setDuration(newdur);
	if (newdur == DURATION_0)
		points = 0;
}

// this compares the name, pitch, octave and accidentals
// returns 1 if it matches ...
int ARNote::CompareNameOctavePitch(const ARNote &nt)
{
	if (name == nt.name
		&& pitch == nt.pitch
		&& octave == nt.octave 
		&& accidentals == nt.accidentals)
		return 1;
	return 0;

}
